/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.availability;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.handler.data.IBorder;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumAvailabilityRegion;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.Zone3D;

public class SubGuiNpcAvailabilityRegions
extends SubGuiInterface
implements ICustomScrollListener {
    private final Availability availability;
    private final Map<String, Integer> data = new TreeMap<String, Integer>();
    private GuiCustomScroll scroll;
    private String select = "";

    public SubGuiNpcAvailabilityRegions(Availability availability) {
        this.setBackground("smallbg.png");
        this.xSize = 176;
        this.ySize = 222;
        this.closeOnEsc = true;
        this.availability = availability;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                if (!this.data.containsKey(this.select)) {
                    return;
                }
                IBorder region = BorderController.getInstance().getRegion(this.data.get(this.select));
                if (region == null) {
                    return;
                }
                IPos iPos = region.getCenter();
                Client.sendData(EnumPacketServer.TeleportTo, region.getDimensionId(), (int)iPos.getX(), (int)iPos.getY(), (int)iPos.getZ());
                break;
            }
            case 1: {
                if (!this.data.containsKey(this.select)) {
                    return;
                }
                int id = this.data.get(this.select);
                if (button.getValue() == 0) {
                    this.availability.regions.remove(id);
                } else if (!this.availability.regions.containsKey(id)) {
                    this.availability.regions.put(id, EnumAvailabilityRegion.Always);
                } else {
                    this.availability.regions.put(id, EnumAvailabilityRegion.values()[button.getValue() - 1]);
                }
                this.func_73866_w_();
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.guiLeft + 5;
        int y = this.guiTop + 197;
        GuiNpcButton button = new GuiNpcButton(66, x, y, 70, 20, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
        int selID = -1;
        if (!this.select.isEmpty() && this.data.containsKey(this.select)) {
            selID = this.data.get(this.select);
        }
        this.data.clear();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(168, 191);
        }
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> suffixes = new ArrayList<String>();
        BorderController bData = BorderController.getInstance();
        char c = '\u00a7';
        TreeMap regionWorlds = new TreeMap();
        for (int id : bData.regions.keySet()) {
            Zone3D region = bData.regions.get(id);
            if (!regionWorlds.containsKey(region.getDimensionId())) {
                regionWorlds.put(region.getDimensionId(), new TreeMap());
            }
            ((Map)regionWorlds.get(region.getDimensionId())).put(id, region);
        }
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        Iterator id = regionWorlds.keySet().iterator();
        while (id.hasNext()) {
            int worldID = (Integer)id.next();
            Iterator iterator = ((Map)regionWorlds.get(worldID)).keySet().iterator();
            while (iterator.hasNext()) {
                int id2 = (Integer)iterator.next();
                Zone3D region = (Zone3D)((Map)regionWorlds.get(worldID)).get(id2);
                IPos iPos = region.getCenter();
                IWorld iWorld = Objects.requireNonNull(NpcAPI.Instance()).getIWorld(worldID);
                String name = new TextComponentTranslation(region.getName(), new Object[0]).func_150254_d();
                ArrayList<String> l = new ArrayList<String>();
                l.add(c + "7Name: " + c + "r" + name);
                l.add(c + "7World ID: " + c + "6" + region.getDimensionId() + c + "7 - " + c + "r" + iWorld.getDimension().getName());
                l.add(c + "7Center in X:" + c + "e" + (int)iPos.getX() + c + "7, Y:" + c + "e" + (int)iPos.getY() + c + "7, Z:" + c + "e" + (int)iPos.getZ());
                hts.put(list.size(), l);
                String key = id2 + " - " + name;
                if (this.availability.regions.containsKey(id2)) {
                    key = c + "r" + key;
                    if (this.availability.regions.get(id2) == EnumAvailabilityRegion.Always) {
                        suffixes.add(c + "aA");
                    } else if (this.availability.regions.get(id2) == EnumAvailabilityRegion.InSide) {
                        suffixes.add(c + "bIn");
                    } else {
                        suffixes.add(c + "dOut");
                    }
                } else {
                    key = c + "7" + key;
                    suffixes.add(c + "cN");
                }
                key = c + "7ID:" + key;
                this.data.put(key, id2);
                if (this.select.isEmpty() || selID == id2) {
                    this.select = key;
                }
                list.add(key);
            }
        }
        this.scroll.setListNotSorted(list);
        this.scroll.setSuffixes(suffixes);
        this.scroll.setHoverTexts(hts);
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 4;
        if (!this.select.isEmpty()) {
            this.scroll.setSelected(this.select);
        }
        this.addScroll(this.scroll);
        EnumAvailabilityRegion aData = null;
        if (!this.select.isEmpty() && this.data.containsKey(this.select) && this.availability.regions.containsKey(this.data.get(this.scroll.getSelected()))) {
            aData = this.availability.regions.get(this.data.get(this.scroll.getSelected()));
        }
        button = new GuiNpcButton(0, x += 73, y, 20, 20, "TP");
        button.setEnabled(!this.select.isEmpty());
        button.setHoverText("hover.teleport", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(1, x + 23, y, 70, 20, new String[]{"gui.disabled", "availability.always", "availability.inside", "availability.outside"}, aData == null ? 0 : aData.ordinal() + 1);
        button.setEnabled(!this.select.isEmpty());
        button.setHoverText("region.hover.available.type", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.select = scroll.getSelected();
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
    }
}

